#ifndef _STACKRULES_H_
#define _STACKRULES_H_

//#include <string>
#include "IAmControlReceiverShadow.h"
#include "AudioStack/AudioSources.h"

//#include "audiomanagertypes.h"


namespace AudioStack
{

struct SourceID;

class clAudioSource;

class clStackRules
{
public:

   clStackRules(SourceID srcID);
   ~clStackRules();

   typedef enum {
      allowed,
      disallowed,
      kicked
   } allow_t;

   typedef enum {
      action_abort   = 0x0100,
      action_waitFor = 0x0200,
      end            = 0xff00,
      mask           = 0xff00,
      idxMask        = 0x00ff
   } actions_t;

   typedef enum {
      typeBg = 0x30,
      typeFg = 0x40,
      typeUI = 0x50,
      typeMix =0x60
   } type_t;
   /* source types */

   typedef enum {
      groupRadio   = 0x10,
      groupMedia   = 0x20,
      groupInternal = 0x30,
      groupNone    = 0x40
   } group_t;
   /* group of source */

   typedef enum {
      registerStatic,
      registerDynamic,
      registerNone
   } registration_t;


   bool setRules(SourceID srcID);
   allow_t allowOnTop(AudioSources::enAudioSources enSrcId);
   actions_t getPushAction(int index);
   actions_t getPopAction(int index);
   type_t getType() {return m_type;}
   group_t getGroup() {return m_group;}
   registration_t getRegistration() {return m_srcReg; }
   tU16 getAvailabilityTimeout() {return m_availabilityTimeout; }
   tBool isAutoPlay() { return m_autoPlay; }

   tS32 getExternalID()
   {
      if(m_rules == NULL)
      {
         return -1;
      }
      return (m_rules->externalID);
   }

   typedef struct {
      const AudioSources::enAudioSources src;
      tU16 externalID;
      type_t type;
      group_t group;
      registration_t sourceRegistration;
      tU16 availabilityTimeout;
      tBool autoPlay;
      void *sourcePointer;
      int allows[16];            /* which source is allowed on top of 'this' source */
      actions_t pushActions[7];  /* which addidional action should be done to the audio stack after pushing source */
      actions_t popActions[7];   /* which addidional action should be done to the audio stack after popping sopuce */
      int mix[10];             /* which source is mixed 'this' source */
   } rules_t;

   static rules_t rules[];
   static int ruleIndex(SourceID srcId);
   static int ruleIndex(AudioSources::enAudioSources srcClass);
   //  protected:
   //  bool checkSrcName(const char *name, void *sourcePointer);
   //int ruleIndex(const char *name);


private:
   clStackRules();
   rules_t*       m_rules;
   type_t         m_type;
   group_t        m_group;
   registration_t m_srcReg;
   tU16           m_availabilityTimeout;
   tBool          m_autoPlay;
};
}
#endif // _STACKRULES_H_
